/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.LOTRShields;
import lotr.common.entity.ai.LOTREntityAIAttackOnCollide;
import lotr.common.entity.ai.LOTREntityAIRangedAttack;
import lotr.common.entity.animal.LOTREntityHorse;
import lotr.common.entity.npc.LOTREntityAvariElf;
import lotr.common.entity.npc.LOTRNPCMount;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class LOTREntityAvariElfWarrior
extends LOTREntityAvariElf {
    public LOTREntityAvariElfWarrior(World world) {
        super(world);
        this.field_70714_bg.func_85156_a(this.rangedAttackAI);
        this.field_70714_bg.func_75776_a(2, this.meleeAttackAI);
        this.spawnRidingHorse = this.field_70146_Z.nextInt(4) == 0;
        this.npcShield = LOTRShields.ALIGNMENT_AVARI;
    }

    @Override
    public LOTRNPCMount createMountToRide() {
        LOTREntityHorse elk = new LOTREntityHorse(this.field_70170_p);
        elk.setMountArmor(new ItemStack(LOTRMod.horseArmorAvari));
        return elk;
    }

    @Override
    protected EntityAIBase createElfRangedAttackAI() {
        return new LOTREntityAIRangedAttack(this, 1.25, 25, 35, 24.0f);
    }

    @Override
    protected EntityAIBase createElfMeleeAttackAI() {
        return new LOTREntityAIAttackOnCollide(this, 1.4, false);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(24.0);
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        int i = this.field_70146_Z.nextInt(6);
        if (i == 0) {
            this.npcItemsInv.setMeleeWeapon(new ItemStack(LOTRMod.pikeAvariElf));
        } else if (i == 1) {
            this.npcItemsInv.setMeleeWeapon(new ItemStack(LOTRMod.spearAvariElf));
        } else {
            this.npcItemsInv.setMeleeWeapon(new ItemStack(LOTRMod.swordAvariElf));
        }
        this.npcItemsInv.setRangedWeapon(new ItemStack(LOTRMod.bowAvariElf));
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.npcItemsInv.setSpearBackup(this.npcItemsInv.getMeleeWeapon());
            this.npcItemsInv.setMeleeWeapon(new ItemStack(LOTRMod.spearAvariElf));
        }
        this.npcItemsInv.setIdleItem(this.npcItemsInv.getMeleeWeapon());
        this.func_70062_b(1, new ItemStack(LOTRMod.bootsAvariElf));
        this.func_70062_b(2, new ItemStack(LOTRMod.legsAvariElf));
        this.func_70062_b(3, new ItemStack(LOTRMod.bodyAvariElf));
        if (this.field_70146_Z.nextInt(10) != 0) {
            this.func_70062_b(4, new ItemStack(LOTRMod.helmetAvariElf));
        } else {
            this.func_70062_b(4, null);
        }
        return data;
    }

    @Override
    public float getAlignmentBonus() {
        return 2.0f;
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendlyAndAligned(entityplayer)) {
            if (this.hiredNPCInfo.getHiringPlayer() == entityplayer) {
                return "avariElf/elf/hired";
            }
            if (LOTRLevelData.getData(entityplayer).getAlignment(this.getFaction()) >= LOTREntityAvariElf.getWoodlandTrustLevel()) {
                return "avariElf/warrior/friendly";
            }
            return "avariElf/elf/neutral";
        }
        return "avariElf/warrior/hostile";
    }
}

